<?php

define('_VALID_XTC',true);
require_once('includes/configure.php');

require_once DIR_FS_CATALOG . 'includes/database_tables.php';

// include needed functions
require_once(DIR_FS_INC . 'xtc_db_connect.inc.php');
require_once(DIR_FS_INC . 'xtc_db_close.inc.php');
require_once(DIR_FS_INC . 'xtc_db_error.inc.php');
require_once(DIR_FS_INC . 'xtc_db_query.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_array.inc.php');
require_once(DIR_FS_INC . 'xtc_db_num_rows.inc.php');
require_once(DIR_FS_INC . 'xtc_db_data_seek.inc.php');
require_once(DIR_FS_INC . 'xtc_db_insert_id.inc.php');
require_once(DIR_FS_INC . 'xtc_db_free_result.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_fields.inc.php');
require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
require_once(DIR_FS_INC . 'xtc_db_output.inc.php');
require_once(DIR_FS_INC . 'xtc_db_input.inc.php');
require_once(DIR_FS_INC . 'xtc_db_prepare_input.inc.php');



xtc_db_connect() or die('Unable to connect to database server!');

// set application wide parameters
$configuration_query = xtc_db_query('select configuration_key as cfgKey, configuration_value as cfgValue from configuration');

while ($configuration = xtc_db_fetch_array($configuration_query))
{
	define($configuration['cfgKey'], $configuration['cfgValue']);
}

// define how the session functions will be used
require(DIR_WS_FUNCTIONS . 'sessions.php');

// set the session name and save path
session_name('XTCsid');

if (STORE_SESSIONS != 'mysql') session_save_path(SESSION_WRITE_DIRECTORY);

// set the session cookie parameters
if (function_exists('session_set_cookie_params'))
{
	session_set_cookie_params(0, '/', (xtc_not_null($current_domain) ? '.' . $current_domain : ''));
}
elseif (function_exists('ini_set'))
{
	ini_set('session.cookie_lifetime', '0');
	ini_set('session.cookie_path', '/');
	ini_set('session.cookie_domain', (xtc_not_null($current_domain) ? '.' . $current_domain : ''));
}

// set the session ID if it exists
if (isset($_POST[session_name()]))
{
	session_id($_POST[session_name()]);
}
elseif ( ($request_type == 'SSL') && isset($_GET[session_name()]) )
{
	session_id($_GET[session_name()]);
}

// start the session
$session_started = false;

if (SESSION_FORCE_COOKIE_USE == 'True')
{
	xtc_setcookie('cookie_test', 'please_accept_for_session', time()+60*60*24*30, '/', $current_domain);

	if (isset($HTTP_COOKIE_VARS['cookie_test']))
	{
		session_start();
		$session_started = true;
	}
}
elseif (CHECK_CLIENT_AGENT == 'True')
{
	$user_agent = strtolower(getenv('HTTP_USER_AGENT'));
	$spider_flag = false;

	if ($spider_flag == false)
	{
		session_start();
		$session_started = true;
	}
}
else
{
	session_start();
	$session_started = true;
}

// verify the ssl_session_id if the feature is enabled
if ( ($request_type == 'SSL') && (SESSION_CHECK_SSL_SESSION_ID == 'True') && (ENABLE_SSL == true) && ($session_started == true) )
{
	$ssl_session_id = getenv('SSL_SESSION_ID');
	if (!session_is_registered('SSL_SESSION_ID'))
	{
		$_SESSION['SESSION_SSL_ID'] = $ssl_session_id;
	}

	if ($_SESSION['SESSION_SSL_ID'] != $ssl_session_id)
	{
		session_destroy();
		xtc_redirect(xtc_href_link(FILENAME_SSL_CHECK));
	}
}

if('Admin' == $_SESSION['customers_status']['customers_status_name'])
{
	require_once DIR_WS_CLASSES . '/contentde/ajaxHandler.class.php';

	new ajaxHandler();
}

?>