<?php

/**
 * Diese Datei bitte nur utf-8 kodieren, da sonst json_encode() nicht mehr funktioniert.
 */

require_once DIR_WS_CLASSES . 'contentde/contentdeApi.class.php';

class ajaxHandler
{
	/**
	 * @var string
	 */
	const CONTENT_DE_SESSION_KEY = '__contentde';

	/**
	 * @var contentdeApi
	 */
	protected $oContentdeApi = null;

	/**
	 * @var bool
	 */
	protected $bRequestFailed = false;

	/**
	 * @var array
	 */
	protected $aErrorMapping = array(
		'not enough balance' => 'Sie haben nicht genug Guthaben. Bitte laden Sie ihr Konto auf.',
		'order title too short' => 'Auftragstitel ist zu kurz.',
		'order description too short' => 'Autorenbriefing ist zu kurz.',
		'project id incorrect' => 'Bitte wählen sie ein richtiges Projekt.',
		'order id incorrect' => 'Ungültige Auftrags-ID.',
		'level incorrect' => 'Bitte geben Sie eine korrekte Einstufung an.',
		'wrong category id' => 'Bitte geben Sie eine korrekte Kategorie an.',
		'Session data outdated or wrong' => 'Ihre content.de Session ist abgelaufen.',
		'no user found' => 'Es konnte kein User gefunden werden.',
		'no categories found' => 'Es konnten keine Kategorien gefunden werden.',
		'no categories/user found' => 'Es konnten keine Kategorien gefunden werden.',
		'values for content rating must be between -2 and 2' => 'Werte für die Bewertung müssen zwischen -2 und 2 liegen.',
		'values for form rating must be between -2 and 2' => 'Werte für die Bewertung müssen zwischen -2 und 2 liegen.',
		'values for readability rating must be between -2 and 2' => 'Werte für die Bewertung müssen zwischen -2 und 2 liegen.',
		'values for communication rating must be between -2 and 2' => 'Werte für die Bewertung müssen zwischen -2 und 2 liegen.',
		'error writing data, please contact support' => 'Daten konnten nicht geschrieben werden.',
		'no orders found to be rated' => 'Es konnte kein Auftrag gefunden werden, der bewertet werden könnte',
		'invalid order-id' => 'Ungültige Auftrags-ID.',
		'no text to revise found' => 'Es konnte kein Text gefunden werden, der in Revision gegeben werden könnte.',
		'no text to reject found' => 'Es konnte kein Text gefunden werden, für den eine Ablehnung beantragt werden könnte.',
		'Please add a  comment' => 'Bitte geben Sie einen Kommentar ein.',
	);

	/**
	 * @return void
	 */
	public function __construct()
	{
		try
		{
			$this->oContentdeApi = new contentdeApi;

			if($this->executeIsLoggedIn())
			{
				$this->oContentdeApi->setSessionHash($this->getSessionValue('sessionHash'));
			}

			$this->execute();
		}
		catch(LogicException $oError)
		{
			// rpc module nicht vorhanden
			// hier evtl was besonderes machen

			$this->sendResponse(false, array('error' => 'Für das content.de Plugin wird eins der folgenden PHP-Module benötigt: xmlrpc, soap'));
		}
		catch(Exception $oError)
		{
			// irgendein anderer fehler

			$this->sendResponse(
				false,
				array(
					'error' => isset($this->aErrorMapping[$oError->getMessage()]) ? $this->aErrorMapping[$oError->getMessage()] : $oError->getMessage()
				)
			);
		}
	}

	/**
	 * @param string $sKey
	 * @return bool
	 */
	protected function hasFormValue($sKey)
	{
		return isset($_REQUEST[$sKey]);
	}

	/**
	 * @param string $sKey
	 * @param mixed $mDefault
	 */
	protected function getFormValue($sKey, $mDefault = null)
	{
		return $this->hasFormValue($sKey) ? $_REQUEST[$sKey] : $mDefault;
	}

	/**
	 * @param string $sKey
	 * @return bool
	 */
	protected function hasSessionValue($sKey)
	{
		return isset($_SESSION[self::CONTENT_DE_SESSION_KEY][$sKey]);
	}

	/**
	 * @param string $sKey
	 * @return mixed $mDefault
	 * @return mixed
	 */
	protected function getSessionValue($sKey, $mDefault = null)
	{
		return $this->hasSessionValue($sKey) ? $_SESSION[self::CONTENT_DE_SESSION_KEY][$sKey] : $mDefault;
	}

	/**
	 * @param string $sKey
	 * @param mixed $mValue
	 */
	protected function setSessionValue($sKey, $mValue)
	{
		if(!isset($_SESSION[self::CONTENT_DE_SESSION_KEY]))
		{
			$_SESSION[self::CONTENT_DE_SESSION_KEY] = array();
		}

		$_SESSION[self::CONTENT_DE_SESSION_KEY][$sKey] = $mValue;
	}

	/**
	 * @return void
	 */
	protected function clearSession()
	{
		$_SESSION[self::CONTENT_DE_SESSION_KEY] = array();
	}

	/**
	 * @param string $bRequestSuccess
	 * @param mixed $mResponse
	 */
	protected function sendResponse($bRequestSuccess, $mResponse)
	{
		echo json_encode(
			array(
				'requestSuccess' => (bool) $bRequestSuccess,
				'response' => $mResponse
			)
		);
	}

	/**
	 * @param string $sType
	 * @param int $iShopId
	 * @param int $iLangid
	 */
	protected function buildExternalId($sType, $iShopId, $iLangId)
	{
		$sHost = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_ADDR'];

		return $sHost . '_' . $sType . '_' . $iLangId . '_' . $iShopId;
	}

	/**
	 * @param string $sType
	 * @param int $iShopId
	 * @param int $iLangid
	 * @return array|bool
	 */
	protected function getOrderData($sType, $iShopId, $iLangId)
	{
		$aPossibleTypes = array('product', 'category');

		if(in_array($sType, $aPossibleTypes))
		{
			$rResult = xtc_db_query('SELECT
										*
									FROM
										content_de_orders
									WHERE
										type = "' . $sType . '"
										AND shop_id = "' . $iShopId . '"
										AND language_id = "' . $iLangId . '"
										AND row_deleted = 0');

			$aRow = mysql_fetch_assoc($rResult);

			if(is_array($aRow))
			{
				return $aRow;
			}
		}

		return false;
	}

	/**
	 * @return array
	 */
	protected function loadTemplates()
	{
		if(!$this->hasSessionValue('templates'))
		{
			$aTemplates = $this->oContentdeApi->getTemplates();

			$aTemplates = array(0 => array('title' => 'Bitte Vorlage w&auml;hlen', 'content' => '')) + $aTemplates;

			$this->setSessionValue('templates', $aTemplates);
		}

		return $this->getSessionValue('templates');
	}

	/**
	 * @return void
	 */
	protected function execute()
	{
		$sAction = $this->getFormValue('action', '');

		$bRequestSuccess = false;

		if(!empty($sAction))
		{
			$sMethod = 'execute' . ucfirst($sAction);

			if(method_exists($this, $sMethod))
			{
				$bRequestSuccess = true;

				$mResponse = call_user_func(array($this, $sMethod));

				if($this->bRequestFailed === true)
				{
					$bRequestSuccess = false;
				}
			}
		}

		$this->sendResponse($bRequestSuccess, $mResponse);
	}

	/**
	 *	@return bool
	 */
	protected function executeIsLoggedIn()
	{
		return ((bool) $this->getSessionValue('isLoggedIn', false)) && strlen($this->getSessionValue('sessionHash', '')) > 0;
	}

	/**
	 * @return bool
	 */
	protected function executeLogin()
	{
		$sUsername = $this->getFormValue('username');
		$sPassword = $this->getFormValue('password');

		$bLoginResult = $this->oContentdeApi->login($sUsername, $sPassword);

		if($bLoginResult)
		{
			$this->setSessionValue('isLoggedIn', true);
			$this->setSessionValue('sessionHash', $this->oContentdeApi->getSessionHash());
		}

		return $bLoginResult;
	}

	/**
	 * @return bool
	 */
	protected function executeLogout()
	{
		$bLogoutResult = $this->oContentdeApi->logout();

		if($bLogoutResult)
		{
			$this->setSessionValue('isLoggedIn', false);
			$this->setSessionValue('sessionHash', '');

			$this->clearSession();
		}

		return $bLogoutResult;
	}

	/**
	 * @return float
	 */
	protected function executeGetBalance()
	{
		return number_format(sprintf('%.2f', $this->oContentdeApi->getBalance()), 2, ',', '');
	}

	/**
	 * @return bool
	 */
	protected function executeHasOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		if($aOrderData !== false)
		{
			return true;
		}

		return false;
	}

	/**
	 * @return bool
	 */
	protected function executeCreateNewOrder()
	{
		$sType = $this->getFormValue('type', 'product');
		$iShopId = $this->getFormValue('shopId', 0);
		$iLangId = $this->getFormValue('langId', 0);

		$sExternalId = $this->buildExternalId($sType, $iShopId, $iLangId);

		$sOrderId = $this->oContentdeApi->placeOrder(
			$this->getFormValue('title'),
			array_unique((array) $this->getFormValue('keywords', array())),
			$this->getFormValue('description'),
			$this->getFormValue('project'),
			$this->getFormValue('category'),
			$this->getFormValue('processingTime'),
			$this->getFormValue('level'),
			$this->getFormValue('minWords'),
			$this->getFormValue('maxWords'),
			1,
			3,
			$sExternalId
		);

		xtc_db_query('INSERT INTO content_de_orders
						(
							type,
							order_id,
							status,
							external_id,
							shop_id,
							language_id,
							text,
							row_deleted
						)
						VALUES
						(
							"' . $sType . '",
							"' . $sOrderId . '",
							"NEW",
							"' . $sExternalId . '",
							"' . $iShopId . '",
							"' . $iLangId . '",
							"",
							0
						)
		');

		return true;
	}

	/**
	 * @return string
	 */
	protected function executeRetrieveOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		//var_dump($aOrderData);

		if($aOrderData !== false)
		{
			$bReady = false;
			$bWaiting = false;
			$sText = '';

			switch(strtolower($aOrderData['status']))
			{
				case 'new':

					$aOrder = $this->oContentdeApi->retrieveOrder($aOrderData['order_id']);


					$aOrder['text']=htmlentities($aOrder['text'],ENT_NOQUOTES , 'UTF-8');
					$aOrder['text']=nl2br($aOrder['text']);
					switch($aOrder['status'])
					{
						// auftrag wartet auf annahme
						case 'waiting':

							$bWaiting = true;
							$sText = $aOrder['text'];

							break;

						// auftrag ist akzeptiert und kann genutzt werden
						case 'accepted':

							$bReady = true;
							$sText = $aOrder['text'];

							xtc_db_query('UPDATE content_de_orders SET status = "RETRIEVED", text = "' . $sText . '" WHERE id = "' . $aOrderData['id'] . '"');

							break;
					}

					break;
				case 'retrieved':
					$bReady = true;
					$bWaiting = false;
					$sText = $aOrderData['text'];
					break;
			}

			return array(
				'ready' => $bReady,
				'waiting' => $bWaiting,
				'text' => $sText
			);
		}

		$this->bRequestFailed = true;
	}

	/**
	 * @return bool
	 */
	protected function executeAcceptOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		if($aOrderData !== false)
		{
			return $this->oContentdeApi->acceptOrder(
				$aOrderData['order_id'],
				$this->getFormValue('review', ''),
				$this->getFormValue('contentRating', 0),
				$this->getFormValue('formRating', 0),
				$this->getFormValue('readabilityRating', 0),
				$this->getFormValue('communicationRating', 0)
			);
		}

		return false;
	}

	/**
	 * @return bool
	 */
	protected function executeReviseOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		if($aOrderData !== false)
		{
			return $this->oContentdeApi->reviseOrder(
				$aOrderData['order_id'],
				$this->getFormValue('review', '')
			);
		}

		return false;
	}

	/**
	 * @return bool
	 */
	protected function executeRejectOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		if($aOrderData !== false)
		{
			return $this->oContentdeApi->rejectOrder(
				$aOrderData['order_id'],
				$this->getFormValue('review', '')
			);
		}

		return false;
	}

	/**
	 * @return array
	 */
	protected function executeGetProjects()
	{
		if(!$this->hasSessionValue('projects'))
		{
			$aProjects = array();

			foreach($this->oContentdeApi->getProjects() as $aProject)
			{
				$aProjects[$aProject['id']] = html_entity_decode($aProject['titel'], ENT_NOQUOTES, 'ISO-8859-15');
			}

			$this->setSessionValue('projects', $aProjects);
		}

		return $this->getSessionValue('projects');
	}

	/**
	 * @return array
	 */
	protected function executeGetCategories()
	{
		if(!$this->hasSessionValue('categories'))
		{
			$aCategories = array();

			foreach($this->oContentdeApi->getCategories() as $aCategory)
			{
				$aCategories[$aCategory['id']] = html_entity_decode($aCategory['titel'], ENT_NOQUOTES, 'UTF-8');
			}

			$this->setSessionValue('categories', $aCategories);
		}

		return $this->getSessionValue('categories');
	}

	/**
	 * @return array
	 */
	protected function executeGetLevels()
	{
		if(!$this->hasSessionValue('levels'))
		{
			$aLevels = array();

			foreach($this->oContentdeApi->getLevels() as $aLevel)
			{
				$sPrice = number_format(sprintf('%.2f', $aLevel['price'] * 100), 2, ',', 0) . ' ct/Wort';

				$aLevels[$aLevel['id']] = html_entity_decode($aLevel['title'], ENT_NOQUOTES, 'ISO-8859-15') . ' / ' . $sPrice;
			}

			$this->setSessionValue('levels', $aLevels);
		}

		return $this->getSessionValue('levels');

	}

	/**
	 * @return array
	 */
	protected function executeGetProcessingTimes()
	{
		$aProcessingTimes = array();

		foreach(array_merge(range(1, 10), array(15), range(20, 50, 10)) as $iProcessingTime)
		{
			$aProcessingTimes[$iProcessingTime] = $iProcessingTime;
		}

		return $aProcessingTimes;
	}

	/**
	 * @return array
	 */
	protected function executeGetTemplateList()
	{
		$aTemplates = $this->loadTemplates();

		foreach($aTemplates as &$aTemplate)
		{
			$aTemplate = $aTemplate['title'];
		}

		return $aTemplates;
	}

	/**
	 * @return array
	 */
	protected function executeGetTemplate()
	{
		$aTemplates = $this->loadTemplates();

		$iTemplateId = $this->getFormValue('template');

		if(isset($aTemplates[$iTemplateId]))
		{
			return $aTemplates[$iTemplateId]['content'];
		}

		return '';
	}

	/**
	 * @return bool
	 */
	protected function executeRequestNewOrder()
	{
		$aOrderData = $this->getOrderData(
			$this->getFormValue('type', 'product'),
			$this->getFormValue('shopId', 0),
			$this->getFormValue('langId', 0)
		);

		if($aOrderData !== false)
		{
			xtc_db_query('UPDATE content_de_orders SET row_deleted = 1 WHERE id = "' . $aOrderData['id'] . '"');

			return true;
		}

		return false;
	}
}

?>