<?php

$bCategory = isset($bCategory) ? $bCategory: false;

$iShopId = null;

if($bCategory)
{
	$iShopId = isset($cInfo->categories_id) ? $cInfo->categories_id : null;
}
else
{
	$iShopId = isset($pInfo->products_id) ? $pInfo->products_id : null;
}

if($iShopId === null)
{
	return;
}

$aUsedLanguage = null;

foreach($languages as $aLanguage)
{
	if($aLanguage['code'] == 'de')
	{
		$aUsedLanguage = $aLanguage;
		break;
	}
}

if($aUsedLanguage === null)
{
	reset($languages);
	$aUsedLanguage = current($languages);
}

$aLanguageOptions = '';

foreach($languages as $aLanguage)
{
	$aLanguageOptions .= '<option value="' . $aLanguage['id'] . '" ' . ($aUsedLanguage['id'] == $aLanguage['id'] ? 'selected="selected"' : '') . '>' . $aLanguage['name'] . '</option>';
}

?>

<script>
var langId = '<?php echo $aUsedLanguage['id'] ?>';
var shopId = '<? echo $iShopId ?>';
var category = <?php echo json_encode($bCategory); ?>;
<?php if($bCategory == true): ?>
var type = 'category';
<?php else: ?>
var type = 'product';
<?php endif; ?>
</script>

<script type="text/javascript" src="includes/javascript/jquery-1.4.2.min.js"></script>
<script type="text/javascript" src="includes/javascript/jquery.domwindow.js"></script>
<script type="text/javascript" src="includes/javascript/content.de.js"></script>

<style>

#contentdeMain {
	margin: 10px 0px;
	padding: 5px;
	border: 1px solid black;

	border: 1px solid #CCC;
	background-color: #f3f3f3;
}

#contentdeMain td {
	font-family:Verdana,Arial,sans-serif;
	font-size:12px;
}

#contentdeNewOrder {
	margin: 10px 0px;
}

.textContainer {
	margin: 10px 0px;
	padding: 5px;
	background-color: #FFF;
}

</style>

<fieldset id="contentdeMain" class="main">
	<legend>content.de</legend>

	<!-- login start -->
	<div id="contentdeLoginForm" style="display: none; margin-bottom: 10px;">
		<table>
			<tr>
				<td>E-Mail</td>
				<td><input type="text" id="login" /></td>
			</tr>
			<tr>
				<td>Passwort</td>
				<td><input type="password" id="password" /></td>
			</tr>
			<tr>
				<td></td>
				<td><input type="button" id="loginSubmit" value="Login" /></td>
			</tr>
		</table>
	</div>
	<!-- login end -->

	<!-- order start -->
	<div id="contentdeOrder" style="display: none; margin-bottom: 10px;">
		<div>
			<input type="button" id="logoutSubmit" value="Logout" />
			<select id="switchLanguage">
				<?php echo $aLanguageOptions ?>
			</select>

			<div>
				Kontostand: <span id="contentdeBalance">0.00</span> Euro
			</div>
		</div>

		<!-- existing order start -->
		<div id="contentdeExistingOrder" style="display: none;">

			<div id="contentdeOrderAccepted" style="display: none; margin: 10px 0px;">
				Der Auftrag ist fertig.

				<div class="textContainer"></div>

				<input type="button" id="applyOrderText" value="Text &uuml;bernehmen" />
				<input type="button" id="requestNewOrder" value="neuen Text schreiben lassen" />
			</div>

			<div id="contentdeOrderWaiting" style="display: none; margin: 10px 0px;">
				Der Auftrag liegt zur Abnahme vor.

				<div class="textContainer"></div>
				<div>
					<input type="button" id="orderAcceptFormButton" value="annehmen" />
					<input type="button" id="orderReviseFormButton" value="in Revision geben" />

				</div>
			</div>

			<div id="contentdeOrderProcessing" style="display: none; margin: 10px 0px;">
				Der Auftrag befindet sich in Bearbeitung.
			</div>
		</div>
		<!-- existing order end -->

		<!-- new order form start -->
		<div id="contentdeNewOrder" style="display: none;">

			<div style="font-weight: bold;">
				Neuen Auftrag bei content.de anlegen
			</div>

			<table cellpadding="0" cellspacing="5">
				<tr>
					<td>Titel</td>
					<td><input type="text" id="newOrderTitle" style="width: 650px;" /></td>
				</tr>
				<tr>
					<td>Projekt</td>
					<td>
						<select id="newOrderProject"></select>
					</td>
				</tr>
				<tr>
					<td>Kategorie</td>
					<td>
						<select id="newOrderCategory"></select>
					</td>
				</tr>
				<tr>
					<td>Qualit&auml;tsniveau</td>
					<td>
						<select id="newOrderLevel"></select>
					</td>
				</tr>
				<tr>
					<td>Bearbeitungsdauer</td>
					<td>
						<select id="newOrderProcessingTime"></select> Tage
					</td>
				</tr>
				<tr>
					<td>Wortanzahl</td>
					<td>
						<input type="text" id="newOrderWordCountMin" value="350" style="width: 50px; text-align: right;" /> bis
						<input type="text" id="newOrderWordCountMax" value="500" style="width: 50px; text-align: right;" /> Worte
					</td>
				</tr>
				<tr>
					<td valign="top">Keywords</td>
					<td>
						<div id="keywordContainer">
						</div>
						<input type="button" id="addNewKeyword" value="Keyword hinzuf&uuml;gen" />
					</td>
				</tr>
				<tr>
					<td valign="top">Autorenbriefing</td>
					<td>
						<textarea id="newOrderDescription" style="width: 650px; height: 400px;"></textarea>
					</td>
				</tr>
				<tr>
					<td>
						Autorenbriefing Vorlage
					</td>
					<td>
						<select id="newOrderTemplate"></select>
					</td>
				</tr>
				<tr>
					<td></td>
					<td>
						<input type="button" value="neuen Auftrag anlegen" id="contentdeCreateNewOrder" />
					</td>
				</tr>
			</table>
		</div>
		<!-- new order form end -->
	</div>
	<!-- order end  -->

	<div id="contentdeButtonContainer">
		<input type="button" value="content.de Formular anzeigen" id="contentdeButton" />

		Dauerhaft anzeigen <input type="checkbox" id="contentdePersistentForm" />
	</div>
</fieldset>

<!-- hier sind Container enthalten die nur nach bedarf angezeigt werden -->
<div style="display: none;">
	<!-- Container der den Prototypen fuer keyword felder -->
	<div id="keywordPrototype">
		<div>
			<input type="text" class="keyword" />
			<input type="button" class="keywordDelete" value=" - " />
		</div>
	</div>

	<!-- container fuer loading images -->
	<div id="loadingImage">
		<img src="data:image/gif;base64,R0lGODlhEAAQAPIAAP///27G6dvw+ZPU7m7G6aXb8bfi88Dm9SH/C05FVFNDQVBFMi4wAwEAAAAh/h1CdWlsdCB3aXRoIEdJRiBNb3ZpZSBHZWFyIDQuMAAh/hVNYWRlIGJ5IEFqYXhMb2FkLmluZm8AIfkECQoAAAAsAAAAABAAEAAAAzMIutz+MMpJaxNjCDoIGZwHTphmCUWxMcK6FJnBti5gxMJx0C1bGDndpgc5GAwHSmvnSAAAIfkECQoAAAAsAAAAABAAEAAAAzQIutz+TowhIBuEDLuw5opEcUJRVGAxGSBgTEVbGqh8HLV13+1hGAeAINcY4oZDGbIlJCoSACH5BAkKAAAALAAAAAAQABAAAAM2CLoyIyvKQciQzJRWLwaFYxwO9BlO8UlCYZircBzwCsyzvRzGqCsCWe0X/AGDww8yqWQan78EACH5BAkKAAAALAAAAAAQABAAAAMzCLpiJSvKMoaR7JxWX4WLpgmFIQwEMUSHYRwRqkaCsNEfA2JSXfM9HzA4LBqPyKRyOUwAACH5BAkKAAAALAAAAAAQABAAAAMyCLpyJytK52QU8BjzTIEMJnbDYFxiVJSFhLkeaFlCKc/KQBADHuk8H8MmLBqPyKRSkgAAIfkECQoAAAAsAAAAABAAEAAAAzMIuiDCkDkX43TnvNqeMBnHHOAhLkK2ncpXrKIxDAYLFHNhu7A195UBgTCwCYm7n20pSgAAIfkECQoAAAAsAAAAABAAEAAAAzIIutz+8AkR2ZxVXZoB7tpxcJVgiN1hnN00loVBRsUwFJBgm7YBDQTCQBCbMYDC1s6RAAAh+QQJCgAAACwAAAAAEAAQAAADMgi63P4wykmrZULUnCnXHggIwyCOx3EOBDEwqcqwrlAYwmEYB1bapQIgdWIYgp5bEZAAADsAAAAAAAAAAAA=" />
	</div>

	<!-- container fuer auftrags annahme -->
	<div id="orderAcceptContainer" style="display:none; border: 1px solid black; padding: 10px;">
		<div>
			<b>Text annehmen</b>
			<br />
			Der voreingestellt Mittelwert bedeutet "genau wie erwartet". Positve oder negative Abweichungen k&ouml;nnen in 2 Stufen angegeben werden.
			<br />
			<table cellpadding="0" cellspacing="5">
				<tr>
					<td style="width: 235px;">
						Inhalt &amp; Vorgabenerf&uuml;llung
					</td>
					<td>
						<input type="radio" name="ratingContent" class="ratingContent" value="-2" />
						<input type="radio" name="ratingContent" class="ratingContent" value="-1" />
						<input type="radio" name="ratingContent" class="ratingContent" value="0" checked="checked" />
						<input type="radio" name="ratingContent" class="ratingContent" value="1" />
						<input type="radio" name="ratingContent" class="ratingContent" value="2" />
					</td>
				</tr>
				<tr>
					<td>
						Rechtschreibung &amp; Grammatik
					</td>
					<td>
						<input type="radio" name="ratingForm" class="ratingForm" value="-2" />
						<input type="radio" name="ratingForm" class="ratingForm" value="-1" />
						<input type="radio" name="ratingForm" class="ratingForm" value="0" checked="checked" />
						<input type="radio" name="ratingForm" class="ratingForm" value="1" />
						<input type="radio" name="ratingForm" class="ratingForm" value="2" />
					</td>
				</tr>
				<tr>
					<td>
						Ausdrucksform &amp; Lesbarkeit
					</td>
					<td>
						<input type="radio" name="ratingReadability" class="ratingReadability" value="-2" />
						<input type="radio" name="ratingReadability" class="ratingReadability" value="-1" />
						<input type="radio" name="ratingReadability" class="ratingReadability" value="0" checked="checked" />
						<input type="radio" name="ratingReadability" class="ratingReadability" value="1" />
						<input type="radio" name="ratingReadability" class="ratingReadability" value="2" />
					</td>
				</tr>
				<tr>
					<td>
						Kommunikation &amp; Termintreue
					</td>
					<td>
						<input type="radio" name="ratingCommunication" class="ratingCommunication" value="-2" />
						<input type="radio" name="ratingCommunication" class="ratingCommunication" value="-1" />
						<input type="radio" name="ratingCommunication" class="ratingCommunication" value="0" checked="checked" />
						<input type="radio" name="ratingCommunication" class="ratingCommunication" value="1" />
						<input type="radio" name="ratingCommunication" class="ratingCommunication" value="2" />
					</td>
				</tr>
				<tr>
					<td valign="top">Rezension</td>
					<td>
						<textarea id="acceptOrderReview" style="width: 350px; height: 200px;"></textarea>
					</td>
				</tr>
				<tr>
					<td>&nbsp;</td>
					<td>
						<input type="button" id="orderAcceptButton" value="annehmen" />
						<input type="button" class="cancelOperation" value="abbrechen" />
					</td>
				</tr>
			</table>
		</div>
	</div>

	<!-- container fuer auftrags revision -->
	<div id="orderReviseContainer">
		<div>
			<b>Text in Revision geben</b>
			<br />
			<table>
				<tr>
					<td valign="top" style="width: 100px;">Begr&uuml;ndung</td>
					<td>
						<textarea id="reviseOrderReview" style="width: 350px; height: 200px;"></textarea>
					</td>
				</tr>
				<tr>
					<td>&nbsp;</td>
					<td>
						<input type="button" id="orderReviseButton" value="in Revision geben" />
						<input type="button" class="cancelOperation" value="abbrechen" />
					</td>
				</tr>
			</table>
		</div>
	</div>

	<!-- container fuer auftrags ablehnung -->
	<div id="orderRejectContainer">
		<div>
			<b>Ablehnung beantragen</b>
			<br />
			<table>
				<tr>
					<td valign="top" style="width: 100px;">Begr&uuml;ndung</td>
					<td>
						<textarea id="rejectOrderReview" style="width: 350px; height: 200px;"></textarea>
					</td>
				</tr>
				<tr>
					<td>&nbsp;</td>
					<td>
						<input type="button" id="orderRejectButton" value="Ablehnung beantragen" />
						<input type="button" class="cancelOperation" value="abbrechen" />
					</td>
				</tr>
			</table>
		</div>
	</div>

</div>