<?php

require_once DIR_WS_CLASSES . 'contentde/rpcModule.class.php';

class contentdeApi
{
	/**
	 * @var string
	 */
	const RPC_MODULE_SOAP = 'soap';

	/**
	 * @var string
	 */
	const RPC_MODULE_XMLRPC = 'xmlrpc';

	/**
	 * @var array
	 */
	private $aModules = array(
		self::RPC_MODULE_SOAP => 'rpcModuleSoap',
		self::RPC_MODULE_XMLRPC => 'rpcModuleXmlrpc'
	);

	/**
	 * @var rpcModule
	 */
	private $oRpcModule = null;

	/**
	 * @var string
	 */
	private $sSessionHash = '';

	/**
	 * @var bool
	 */
	private $bLoggedIn = false;

	/**
	 * @return void
	 */
	public function __construct()
	{
		$this->determineRpcModule();
	}

	/**
	 * @return void
	 */
	private function determineRpcModule()
	{
		foreach($this->aModules as $sModule => $sClass)
		{
			if(extension_loaded($sModule))
			{
				$this->oRpcModule = new $sClass;

				if(!($this->oRpcModule instanceof rpcModule))
				{
					throw new LogicException('invalid rpc module class');
				}

				return;
			}
		}

		throw new LogicException('there is no possible rpc module');
	}

	/**
	 * @return bool
	 */
	public function login($sLogin, $sPassword)
	{
		if(!$this->isLoggedIn())
		{
			$this->bLoggedIn = false;

			try
			{
				$sResult = $this->oRpcModule->doRequest('login', $sLogin, $sPassword);

				if(preg_match('/User Data invalid/i', $sResult) == 0)
				{
					$this->sSessionHash = $sResult;

					$this->bLoggedIn = true;

					return true;
				}
			}
			catch(Exception $oError)
			{
			}

			return false;
		}

		return true;
	}

	/**
	 * @return bool
	 */
	public function isLoggedIn()
	{
		return $this->bLoggedIn;
	}

	/**
	 * @return bool
	 */
	public function logout()
	{
		try
		{
			if($this->isLoggedIn())
			{
				$this->oRpcModule->doRequest('logout', $this->sSessionHash);

				return true;
			}
		}
		catch(Exception $oError)
		{
		}

		return false;
	}

	/**
	 * @return void
	 */
	public function setSessionHash($sSessionHash)
	{
		$this->sSessionHash = $sSessionHash;

		$this->bLoggedIn = true;
	}

	/**
	 * @return string
	 */
	public function getSessionHash()
	{
		return $this->sSessionHash;
	}

	/**
	 * @param string $sOrderId
	 * @return array
	 */
	public function retrieveOrder($sOrderId)
	{
		$aOrderData = $this->oRpcModule->doRequest('getOrderById', $this->sSessionHash, $sOrderId);

		return $aOrderData['Records'];
	}

	/**
	 * @return string
	 */
	public function placeOrder($sTitle, $aKeywords, $sDesciption, $sProject, $iCategory, $iDuration = 3, $iLevel = 4, $iMin=200, $iMax = 500, $iMinDensity = 2, $iMaxDensity = 5, $sExternalId = '')
	{
		$aResult = $this->oRpcModule->doRequest(
			'createOpenOrder',
			$this->sSessionHash,
			$sTitle,
			$aKeywords,
			$sDesciption,
			$sProject,
			$iCategory,
			$iDuration,
			$iLevel,
			$iMin,
			$iMax,
			$iMinDensity,
			$iMaxDensity,
			$sExternalId
		);

		return $aResult['Records'];
	}

	/**
	 * @param string $sOrderId
	 * @param string $sReview
	 * @param int $iContentRating
	 * @param int $iFormRating
	 * @param int $iReadabilityRating
	 * @param int $iCommunicationRating
	 * @return bool
	 */
	public function acceptOrder($sOrderId, $sReview, $iContentRating, $iFormRating, $iReadabilityRating, $iCommunicationRating)
	{
		try
		{
			$this->oRpcModule->doRequest(
				'rateAndAcceptOrder',
				$this->sSessionHash,
				$sOrderId,
				$sReview,
				(int) $iContentRating,
				(int) $iFormRating,
				(int) $iReadabilityRating,
				(int) $iCommunicationRating
			);

			return true;
		}
		catch(Exception $oError)
		{
			var_dump($oError->getMessage());
		}

		return false;
	}

	/**
	 * @param string $sOrderId
	 * @param string $sReview
	 * @return bool
	 */
	public function reviseOrder($sOrderId, $sReview)
	{
		try
		{
			$this->oRpcModule->doRequest('requestRevision', $this->sSessionHash, $sOrderId, $sReview);

			return true;
		}
		catch(Exception $oError)
		{
		}

		return false;
	}

	/**
	 * @param string $sOrderId
	 * @param string $sReview
	 * @return bool
	 */
	public function rejectOrder($sOrderId, $sReview)
	{
		try
		{
			$this->oRpcModule->doRequest('requestRejection', $this->sSessionHash, $sOrderId, $sReview);

			return true;
		}
		catch(Exception $oError)
		{
		}

		return false;
	}

	/**
	 * @return float
	 */
	public function getBalance()
	{
		$aBalance = $this->oRpcModule->doRequest('getBalance', $this->sSessionHash);

		return (float) $aBalance['Records']['available'];
	}

	/**
	 * @return array
	 */
	public function getCategories()
	{
		$aResult = $this->oRpcModule->doRequest('getCategories', $this->sSessionHash);

		return $aResult['Records'];
	}

	/**
	 * @return array
	 */
	public function getProjects()
	{
		$aResult = $this->oRpcModule->doRequest('getProjects', $this->sSessionHash);

		return $aResult['Records'];
	}

	/**
	 * @return array
	 */
	public function getLevels()
	{
		$aResult = $this->oRpcModule->doRequest('getLevels', $this->sSessionHash);

		return $aResult['Records'];
	}

	/**
	 * @return array
	 */
	public function getTemplates()
	{
		$aResult = $this->oRpcModule->doRequest('getTemplates', $this->sSessionHash);

		$aTemplates = array();

		foreach($aResult['Records'] as &$aTemplate)
		{
			$aTemplates[$aTemplate['id']] = &$aTemplate;

			unset($aTemplate['id']);
		}

		return $aTemplates;
	}
}

?>