
var animSpeed = 'slow';
var errorMsg = 'Es ist ein unbekannter Fehler aufgetreten!';
var loggedIn = false;
var loginChecked = false;
var formVisible = false;

var text = '';

function ajaxCallback(callback)
{
	return function (data) {

		if(data.requestSuccess)
		{
			callback(data);

			return;
		}

		if(data.response.error && data.response.error.length > 0)
		{
			alert(data.response.error);
		}
		else
		{
			alert(errorMsg);
		}
	}
}

function fillSelect(selector, data, selected)
{
	var options = '';

	for(var value in data)
	{
		var name = data[value];

		var selectedString = selected == value ? 'selected="selected"' : '';

		options += '<option value="' + value + '" ' + selectedString + '>' + name + '</option>';
	}

	$(selector).append(options);
}

function ajaxFillSelect(selector, ajaxAction, selected)
{
	$(selector).empty().attr('disabled', true).after($('#loadingImage').html());

	$.ajax({
		'data': {'action': ajaxAction},
		'success': ajaxCallback(function (data) {
			if(data.response)
			{
				fillSelect(selector, data.response, selected);

				$(selector).attr('disabled', false).next().remove();
			}
		})
	});
}

function getBalance()
{
	$.ajax({
		'data': {'action': 'getBalance'},
		'success': function (data) {
			$('#contentdeBalance').text(data.response);
		}
	})
}

function showExistingOrder()
{
	text = '';

	getBalance();

	$.ajax({
		'data': {'action': 'retrieveOrder', 'type': type, 'shopId': shopId, 'langId': langId},
		'success': ajaxCallback(function (data) {

			text = data.response.text;

			if(data.response.ready)
			{
				// text ist verfuegbar

				$('.textContainer').html(text);

				$('#contentdeOrderProcessing').hide(animSpeed);
				$('#contentdeOrderWaiting').hide(animSpeed);
				$('#contentdeOrderAccepted').show(animSpeed);
			}
			else if(data.response.waiting)
			{
				// text muss noch angenommen werden

				$('.textContainer').html(text);

				$('#contentdeOrderProcessing').hide(animSpeed);
				$('#contentdeOrderWaiting').show(animSpeed);
				$('#contentdeOrderAccepted').hide(animSpeed)
			}
			else
			{
				// text ist noch nicht verfuegbar

				$('#contentdeOrderProcessing').show(animSpeed);
				$('#contentdeOrderWaiting').hide(animSpeed);
				$('#contentdeOrderAccepted').hide(animSpeed)
			}
		})
	});

	$('#contentdeExistingOrder').show(animSpeed);
}

function showNewOrder()
{
	ajaxFillSelect('#newOrderProject', 'getProjects');
	ajaxFillSelect('#newOrderCategory', 'getCategories');
	ajaxFillSelect('#newOrderLevel', 'getLevels', 10);
	ajaxFillSelect('#newOrderProcessingTime', 'getProcessingTimes', 3);
	ajaxFillSelect('#newOrderTemplate', 'getTemplateList');

	$('#contentdeNewOrder').show(animSpeed);
}

function showOrder()
{
	getBalance();

	$.ajax({
		'data': {'action': 'hasOrder', 'type': type, 'shopId': shopId, 'langId': langId},
		'success': ajaxCallback(function (data) {
			$('#contentdeOrder').show(animSpeed);

			if(data.response)
			{
				// es gibt bereits einen Auftrag dazu, also div zum uebernehmen der Daten anzeigen

				showExistingOrder();
				$('#contentdeNewOrder').hide(animSpeed);
			}
			else
			{
				// es gibt noch keinen auftrag, also "auftrag anlegen"-Formular anzeigen

				$('#contentdeExistingOrder').hide(animSpeed);
				showNewOrder();
			}
		})
	});
}

$(document).ready(function () {

	// setup
	// --------------------------------------

	$.ajaxSetup({
		'url': '/admin/content_de.php',
		'type': 'POST',
		'dataType': 'json',
		'error': function () {
			alert('Ajax Request fehlgeschlagen.');
		}
	});

	// --------------------------------------

	$('#contentdeButton').click(function () {

		if(formVisible)
		{
			// formular sichtbar

			$('#contentdeOrder, #contentdeLoginForm').hide(animSpeed);

			formVisible = false;
			$('#contentdeButton').val('content.de Formular anzeigen');
		}
		else
		{
			// formular nicht sichtbar

			if(loginChecked == false)
			{
				loginChecked = true;

				$.ajax({
					'async': false,
					'data': {'action': 'isLoggedIn'},
					'success': ajaxCallback(function (data) {
						loggedIn = data.response ? true : false;
					})
				});
			}

			if(loggedIn)
			{
				showOrder();
				$('#contentdeLoginForm').hide(animSpeed);
			}
			else
			{
				$('#contentdeOrder').hide(animSpeed);
				$('#contentdeLoginForm').show(animSpeed);
			}

			formVisible = true;
			$('#contentdeButton').val('content.de Formular ausblenden');
		}
	});

	$('#loginSubmit').click(function () {

		var login = $('#login').val(), password = $('#password').val();

		if(login.length > 0 && password.length > 0)
		{
			$.ajax({
				'data': {'action': 'login', 'username': login, 'password': password},
				'success': ajaxCallback(function (data) {
					loggedIn = data.response ? true : false;

					if(loggedIn)
					{
						$('#login').val('');
						$('#password').val('');

						showOrder();
						$('#contentdeLoginForm').hide(animSpeed);
					}
					else
					{
						alert('Sie konnten nicht eingeloggt werden. Bitte berprfen Sie die Zugangsdaten.');
					}
				})
			});


			return;
		}

		alert('Bitte geben Sie Ihre Zugangsdaten ein.');
	});

	$('#logoutSubmit').click(function () {
		if(loggedIn)
		{
			$.ajax({
				'data': {'action': 'logout'},
				'success': ajaxCallback(function (data) {
					loggedIn = !data.response ? true : false;

					if(!loggedIn)
					{
						$('#contentdeOrder').hide(animSpeed);
						$('#contentdeLoginForm').show(animSpeed);
					}
				})
			});

			return;
		}

		alert('Sie sind nicht eingeloggt.');
	});

	$('#addNewKeyword').click(function () {
		$('#keywordContainer').append($('#keywordPrototype').html()).find('.keywordDelete:last').click(function () {
			$(this).parent().remove();
		});
	});

	$('#contentdeCreateNewOrder').click(function () {

		var title = $('#newOrderTitle').val();
		var description = $('#newOrderDescription').val();
		var minWords = $('#newOrderWordCountMin').val();
		var maxWords = $('#newOrderWordCountMax').val();
		var keywords = [];

		if(title.length == 0)
		{
			alert('Bitte geben Sie einen Titel ein!');
			return;
		}

		if(description.length == 0)
		{
			alert('Bitte geben Sie ein Autorenbriefing ein!');
			return;
		}

		if(minWords.length == 0)
		{
			alert('Bitte geben sie eine Mindestlnge fr den Auftrag ein!');
			return;
		}

		if(maxWords.length == 0)
		{
			alert('Bitte geben sie eine Maximallnge fr den Auftrag ein!');
			return;
		}

		$('.keyword').each(function () {

			var newKeyword = $.trim($(this).val());

			if(newKeyword.length > 0)
			{
				keywords.push(newKeyword);
			}
		});

		$.ajax({
			'data': {
				'action': 'createNewOrder',
				'type': type,
				'shopId': shopId,
				'langId': langId,

				// parameter fuer den auftrag
				'title': title,
				'description': description,
				'minWords': minWords,
				'maxWords': maxWords,
				'project': $('#newOrderProject').val(),
				'category': $('#newOrderCategory').val(),
				'level': $('#newOrderLevel').val(),
				'processingTime': $('#newOrderProcessingTime').val(),
				'keywords[]': keywords
			},
			'success': ajaxCallback(function (data) {
				if(data.response)
				{
					// auftrag erfolgreich angelegt.

					alert('Auftrag wurde erfolgreich angelegt.');

					showExistingOrder();
					$('#contentdeNewOrder').hide(animSpeed);
				}
				else
				{
					alert('Auftrag konnte nicht erstellt werden.');
				}
			})
		});
	});

	$('#applyOrderText').click(function () {
		
		var textFieldId = 'products_description_' + langId;

		if(category)
		{
			textFieldId = 'categories_description\\[' + langId + '\\]';
		}

		if(typeof(FCKeditorAPI) != "undefined")
		{
			textFieldId = textFieldId.replace(/\\\[/, '[').replace(/\\\]/, ']');
			FCKeditorAPI.GetInstance(textFieldId).SetHTML(text);
			textFieldId = textFieldId.replace(/\[/, '\\[').replace(/\]/, '\\]');
		}
		else
		{
			$('#' + textFieldId).val(text);
		}

		window.scrollTo(0, $('#' + textFieldId).parent().offset().top - 100);
	});

	$('#orderAcceptFormButton').openDOMWindow({
		'eventType': 'click',
		'windowSourceID': '#orderAcceptContainer',
		'width': 620,
		'height': 420,
		'modal': true
	});

	$('#orderAcceptButton').click(function () {

		var ratingContent = $('.ratingContent:checked').val();
		var ratingForm = $('.ratingForm:checked').val();
		var ratingReadability = $('.ratingReadability:checked').val();
		var ratingCommunication = $('.ratingCommunication:checked').val();

		var review = $('#acceptOrderReview').val();

		if(review.length < 1)
		{
			alert('Bitte geben Sie eine Rezension ein.');
			return;
		}

		if(ratingContent == undefined || ratingForm == undefined || ratingReadability == undefined || ratingCommunication == undefined)
		{
			alert('Bitte geben Sie eine Bewertung an.');
			return;
		}

		$.ajax({
			'data': {
				'action': 'acceptOrder',
				'type': type,
				'shopId': shopId,
				'langId': langId,

				'review': review,
				'contentRating': ratingContent,
				'formRating': ratingForm,
				'readabilityRating': ratingReadability,
				'communicationRating': ratingCommunication
			},
			'success': ajaxCallback(function (data) {
				if(data.response)
				{
					$('.ratingContent[value="0"]').attr('checked', true);
					$('.ratingForm[value="0"]').attr('checked', true);
					$('.ratingReadability[value="0"]').attr('checked', true);
					$('.ratingCommunication[value="0"]').attr('checked', true);
					$('#acceptOrderReview').val('');
					alert('Auftrag wurde erfolgreich angenommen.');
					$('.cancelOperation').click();
					showExistingOrder();
					return;
				}

				alert('Es trat ein Fehler bei der Annahme des Textes auf.');
			})
		});
	});

	$('#orderReviseFormButton').openDOMWindow({
		'eventType': 'click',
		'windowSourceID': '#orderReviseContainer',
		'width': 450,
		'height': 260,
		'modal': true
	});

	$('#orderReviseButton').click(function () {

		var review = $('#reviseOrderReview').val();

		if(review.length < 1)
		{
			alert('Bitte geben Sie eine Begrndung ein.');
			return;
		}

		$.ajax({
			'data' : {
				'action': 'reviseOrder',
				'type': type,
				'shopId': shopId,
				'langId': langId,
				'review': review
			},
			'success': ajaxCallback(function (data) {
				if(data.response)
				{
					$('#reviseOrderReview').val('');
					alert('Der Auftrag wurde erfolgreich in Revision gegeben.');
					$('.cancelOperation').click();
					showExistingOrder();
					return;
				}

				alert('Es trat ein Fehler auf.');
			})
		});
	});


	$('.cancelOperation').closeDOMWindow({
		'eventType': 'click'
	});

	$('#switchLanguage').change(function () {
		langId = $(this).val();

		showOrder();
	});

	$('#newOrderTemplate').change(function () {
		$.ajax({
			'data': {
				'action': 'getTemplate',
				'template': $(this).val()
			},
			'success': ajaxCallback(function (data) {
				$('#newOrderDescription').val('');
				if(data.response)
				{
					$('#newOrderDescription').val(data.response);
				}
			})
		});
	});

	$('#contentdePersistentForm').click(function () {

		var newCookie = 'p_contentde_form=1;';

		if(!$(this).attr('checked'))
		{
			// cookie loeschen

			newCookie += 'expires=Thu, 01-Jan-70 00:00:01 GMT;';
		}

		document.cookie = newCookie;
	});

	$('#requestNewOrder').click(function () {

		$.ajax({
			'data': {
				'action': 'requestNewOrder',
				'type': type,
				'shopId': shopId,
				'langId': langId
			},
			'success': function (data) {
				if(data.response)
				{
					showOrder();
				}
			}
		});

	});


	// --------------------------------

	if(document.cookie && document.cookie.search(/p_contentde_form=1/) >= 0)
	{
		$('#contentdePersistentForm').attr('checked', true);

		animSpeed = null;

		$('#contentdeButton').click();

		setTimeout(function () { animSpeed = 'slow' }, 1000);
	}
});
